<?php  // $Id: view.php,v 1.6.2.3 2009/04/17 22:06:25 skodak Exp $

/**
 * This page prints a particular instance of moodlekrem
 *
 * @author  Your Name <your@email.address>
 * @version $Id: view.php,v 1.6.2.3 2009/04/17 22:06:25 skodak Exp $
 * @package mod/moodlekrem
 */

require_once(dirname(dirname(dirname(__FILE__))).'/config.php');
require_once(dirname(__FILE__).'/lib.php');

$id = optional_param('id', 0, PARAM_INT); // course_module ID, or
$a  = optional_param('a', 0, PARAM_INT);  // moodlekrem instance ID

if ($id) {
    if (! $cm = get_coursemodule_from_id('moodlekrem', $id)) {
        error('Course Module ID was incorrect');
    }

    if (! $course = get_record('course', 'id', $cm->course)) {
        error('Course is misconfigured');
    }

    if (! $moodlekrem = get_record('moodlekrem', 'id', $cm->instance)) {
        error('Course module is incorrect');
    }

} else if ($a) {
    if (! $moodlekrem = get_record('moodlekrem', 'id', $a)) {
        error('Course module is incorrect');
    }
    if (! $course = get_record('course', 'id', $moodlekrem->course)) {
        error('Course is misconfigured');
    }
    if (! $cm = get_coursemodule_from_instance('moodlekrem', $moodlekrem->id, $course->id)) {
        error('Course Module ID was incorrect');
    }

} else {
    error('You must specify a course_module ID or an instance ID');
}

require_login($course, true, $cm);

add_to_log($course->id, "moodlekrem", "view", "view.php?id=$cm->id", "$moodlekrem->id");

if (isstudent($course->id, $USER->id)) {
    //Pohled studenta
    $gid = $moodlekrem->id;
    $cid = $course->id;
    $uid = $USER->id;
    moodlekrem_showmodel($gid,$cid,$uid);
} else {
    // Pohled vyučujícího
    /// Print the page header
    $strmoodlekrems = get_string('modulenameplural', 'moodlekrem');
    $strmoodlekrem  = get_string('modulename', 'moodlekrem');

    $navlinks = array();
    $navlinks[] = array('name' => $strmoodlekrems, 'link' => "index.php?id=$course->id", 'type' => 'activity');
    $navlinks[] = array('name' => format_string($moodlekrem->name), 'link' => '', 'type' => 'activityinstance');

    $navigation = build_navigation($navlinks);

    print_header_simple(format_string($moodlekrem->name), '', $navigation, '', '', true,
              update_module_button($cm->id, $course->id, $strmoodlekrem), navmenu($course, $cm));

    /// Print the main part of the page
    echo "<h1>".get_string('moodlekremshowname', 'moodlekrem')."</h1><br>";
    echo "<i>".get_string('moodlekremchocestudent', 'moodlekrem').":</i><br><br>";
    require_once('../../config.php');
    require_once($CFG->libdir.'/tablelib.php');
    $user = $USER;
    $tablecolumns = array('userpic', 'fullname','status','glikrem');
    $tableheaders = array(get_string('userpic'), get_string('fullname'), 'Status', 'GLIKREM');

    $table = new flexible_table('user-index-participants-'.$course->id);

    $table->define_columns($tablecolumns);
    $table->define_headers($tableheaders);
    $table->cellpadding = 20;
    $table->cellspacing = 20;
    $table->set_attribute('id', 'participants');
    $table->set_attribute('class', 'generaltable generalbox');
    $table->set_control_variables(array(
                TABLE_VAR_SORT    => 'ssort',
                TABLE_VAR_HIDE    => 'shide',
                TABLE_VAR_SHOW    => 'sshow',
                TABLE_VAR_IFIRST  => 'sifirst',
                TABLE_VAR_ILAST   => 'silast',
                TABLE_VAR_PAGE    => 'spage'
                ));
    $table->setup();
    $select = "SELECT u.id, u.username, u.firstname, u.lastname,
            u.email, u.city, u.country, u.picture,
            u.lang, u.timezone, u.emailstop, u.maildisplay, u.imagealt,
            u.lastaccess FROM {$CFG->prefix}user u
            JOIN {$CFG->prefix}role_assignments r
            ON u.id=r.userid
            LEFT OUTER JOIN {$CFG->prefix}user_lastaccess ul
            ON (r.userid=ul.userid and ul.courseid = $course->id)
            WHERE u.deleted = 0 AND (ul.courseid = $course->id)
            AND r.roleid = 5
            AND u.username != 'guest' ORDER BY u.lastname";
    $userlist = get_recordset_sql($select);
    if ($userlist)  {
            $usersprinted = array();
            while ($user = rs_fetch_next_record($userlist)) {
                if (in_array($user->id, $usersprinted)) { /// Prevent duplicates by r.hidden - MDL-13935
                    continue;
                }
                $usersprinted[] = $user->id; /// Add new user to the array of users printed

                $user = make_context_subobj($user);
                if ( !empty($user->hidden) ) {
                // if the assignment is hidden, display icon
                    $hidden = " <img src=\"{$CFG->pixpath}/t/show.gif\" title=\"".get_string('userhashiddenassignments', 'role')."\" alt=\"".get_string('hiddenassign')."\" class=\"hide-show-image\"/>";
                } else {
                    $hidden = '';
                }

                if (!isset($user->context)) {
                    $usercontext = get_context_instance(CONTEXT_USER, $user->id);
                } else {
                    $usercontext = $user->context;
                }
                
                $profilelink = '<strong><a href="'.$CFG->wwwroot.'/user/view.php?id='.$user->id.'&amp;course='.$course->id.'">'.fullname($user).'</a></strong>';

                $data = array (
                        print_user_picture($user, $course->id, $user->picture, false, true, $piclink),
                        $profilelink . $hidden);

                //Zjištění splnění/nesplnění modelu ???
                $u_gid = $moodlekrem->id;
                $u_cid = $course->id;
                $u_uid = $user->id;

                // Zde jsou odkazy
                $u_st = moodlekrem_get_status($u_gid, $u_cid, $u_uid);
                if ($u_st == 0) {
                    $data[] = '<font color=red>&nbsp;'.get_string('moodlekremstatusno', 'moodlekrem').'&nbsp;</font>';
                }
                if ($u_st == 1) {
                    $data[] = '<font color=green>&nbsp;'.get_string('moodlekremstatusyes', 'moodlekrem').'&nbsp;</font>';
                }
                if ($u_st == 2) {
                    $data[] = '<font color=magenta>&nbsp;'.get_string('moodlekremstatusnone', 'moodlekrem').'&nbsp;</font>';
                }

                $data[] = '<a href='.$CFG->wwwroot.'/mod/moodlekrem/showmodel.php'.'?id='.$cm->id.'&gid='.$u_gid.'&cid='.$u_cid.'&uid='.$u_uid.' target=_top>&nbsp;'.get_string('moodlekremshow', 'moodlekrem').'&nbsp;</a>';

                $table->add_data($data);
            }
    }
    $table->print_html();

    /// Finish the page
    print_footer($course);
}
?>
