<?php  // $Id: lib.php,v 1.7.2.5 2009/04/22 21:30:57 skodak Exp $

/**
 * Library of functions and constants for module moodlekrem
 * This file should have two well differenced parts:
 *   - All the core Moodle functions, neeeded to allow
 *     the module to work integrated in Moodle.
 *   - All the moodlekrem specific functions, needed
 *     to implement all the module logic. Please, note
 *     that, if the module become complex and this lib
 *     grows a lot, it's HIGHLY recommended to move all
 *     these module specific functions to a new php file,
 *     called "locallib.php" (see forum, quiz...). This will
 *     help to save some memory when Moodle is performing
 *     actions across all modules.
 */

/// (replace moodlekrem with the name of your module and delete this line)

$moodlekrem_EXAMPLE_CONSTANT = 42;     /// for example


/**
 * Given an object containing all the necessary data,
 * (defined by the form in mod_form.php) this function
 * will create a new instance and return the id number
 * of the new instance.
 *
 * @param object $moodlekrem An object from the form in mod_form.php
 * @return int The id of the newly inserted moodlekrem record
 */
function moodlekrem_add_instance($moodlekrem) {

    $moodlekrem->timecreated = time();

    # You may have to add extra stuff in here #

    return insert_record('moodlekrem', $moodlekrem);
}


/**
 * Given an object containing all the necessary data,
 * (defined by the form in mod_form.php) this function
 * will update an existing instance with new data.
 *
 * @param object $moodlekrem An object from the form in mod_form.php
 * @return boolean Success/Fail
 */
function moodlekrem_update_instance($moodlekrem) {

    $moodlekrem->timemodified = time();
    $moodlekrem->id = $moodlekrem->instance;

    # You may have to add extra stuff in here #

    return update_record('moodlekrem', $moodlekrem);
}


/**
 * Given an ID of an instance of this module,
 * this function will permanently delete the instance
 * and any data that depends on it.
 *
 * @param int $id Id of the module instance
 * @return boolean Success/Failure
 */
function moodlekrem_delete_instance($id) {

    if (! $moodlekrem = get_record('moodlekrem', 'id', $id)) {
        return false;
    }

    $result = true;

    # Delete any dependent records here #

    if (! delete_records('moodlekrem', 'id', $moodlekrem->id)) {
        $result = false;
    }

    return $result;
}


/**
 * Return a small object with summary information about what a
 * user has done with a given particular instance of this module
 * Used for user activity reports.
 * $return->time = the time they did it
 * $return->info = a short text description
 *
 * @return null
 * @todo Finish documenting this function
 */
function moodlekrem_user_outline($course, $user, $mod, $moodlekrem) {
    return $return;
}


/**
 * Print a detailed representation of what a user has done with
 * a given particular instance of this module, for user activity reports.
 *
 * @return boolean
 * @todo Finish documenting this function
 */
function moodlekrem_user_complete($course, $user, $mod, $moodlekrem) {
    return true;
}


/**
 * Given a course and a time, this module should find recent activity
 * that has occurred in moodlekrem activities and print it out.
 * Return true if there was output, or false is there was none.
 *
 * @return boolean
 * @todo Finish documenting this function
 */
function moodlekrem_print_recent_activity($course, $isteacher, $timestart) {
    return false;  //  True if anything was printed, otherwise false
}


/**
 * Function to be run periodically according to the moodle cron
 * This function searches for things that need to be done, such
 * as sending out mail, toggling flags etc ...
 *
 * @return boolean
 * @todo Finish documenting this function
 **/
function moodlekrem_cron () {
    global $CFG;

    $now = make_timestamp(date('Y'), date('m'), date('d'), date('H'), date('i'),date('s'));
    $delay = $now - ($CFG->moodlekrem_delay * 86400); //X dní zpátky ... viz settings

    $sql = "timecroned<".$delay." ORDER BY timecroned DESC";
    //$glikrems = get_records("moodlekrem", "", "", "timecroned DESC");
    $glikrem = get_record_select("moodlekrem",$sql);
    //$glik = $glikrems[0];
    $gid = $glikrem->id;
    $cid = $glikrem->course;

    $status = get_record("course", "id", $cid, "visible", 1);

    if ($status) {
        $glikrem->timecroned = $now;
        update_record("moodlekrem", $glikrem);

        mtrace("MoodleKREM: (".$gid.") ".$glikrem->name);
        moodlekrem_create_base_record($gid, $cid);

        $sql = "SELECT u.id, u.username, u.firstname, u.lastname,
            u.email, u.city, u.country, u.picture,
            u.lang, u.timezone, u.emailstop, u.maildisplay, u.imagealt,
            u.lastaccess FROM {$CFG->prefix}user u
            JOIN {$CFG->prefix}role_assignments r
            ON u.id=r.userid
            LEFT OUTER JOIN {$CFG->prefix}user_lastaccess ul
            ON (r.userid=ul.userid and ul.courseid = $cid)
            WHERE u.deleted = 0 AND (ul.courseid = $cid)
            AND r.roleid = 5
            AND u.username != 'guest' ORDER BY u.lastname";
        $users = get_records_sql($sql);
        foreach ($users as $user) {
           $uid = $user->id;
            moodlekrem_create_user_record($gid, $cid, $uid);
            $status = moodlekrem_get_status($gid, $cid, $uid);
            $string = "GLIKREM: ".$user->firstname." ".$user->lastname." --> status = ".$status;
            mtrace($string);
        }
    }
 
    return true;
}


/**
 * Must return an array of user records (all data) who are participants
 * for a given instance of moodlekrem. Must include every user involved
 * in the instance, independient of his role (student, teacher, admin...)
 * See other modules as example.
 *
 * @param int $moodlekremid ID of an instance of this module
 * @return mixed boolean/array of students
 */
function moodlekrem_get_participants($moodlekremid) {
    return false;
}


/**
 * This function returns if a scale is being used by one moodlekrem
 * if it has support for grading and scales. Commented code should be
 * modified if necessary. See forum, glossary or journal modules
 * as reference.
 *
 * @param int $moodlekremid ID of an instance of this module
 * @return mixed
 * @todo Finish documenting this function
 */
function moodlekrem_scale_used($moodlekremid, $scaleid) {
    $return = false;

    //$rec = get_record("moodlekrem","id","$moodlekremid","scale","-$scaleid");
    //
    //if (!empty($rec) && !empty($scaleid)) {
    //    $return = true;
    //}

    return $return;
}


/**
 * Checks if scale is being used by any instance of moodlekrem.
 * This function was added in 1.9
 *
 * This is used to find out if scale used anywhere
 * @param $scaleid int
 * @return boolean True if the scale is used by any moodlekrem
 */
function moodlekrem_scale_used_anywhere($scaleid) {
    if ($scaleid and record_exists('moodlekrem', 'grade', -$scaleid)) {
        return true;
    } else {
        return false;
    }
}


/**
 * Execute post-install custom actions for the module
 * This function was added in 1.9
 *
 * @return boolean true if success, false on error
 */
function moodlekrem_install() {
    return true;
}


/**
 * Execute post-uninstall custom actions for the module
 * This function was added in 1.9
 *
 * @return boolean true if success, false on error
 */
function moodlekrem_uninstall() {
    return true;
}


//////////////////////////////////////////////////////////////////////////////////////
/// Any other moodlekrem functions go here.  Each of them must have a name that
/// starts with moodlekrem_
/// Remember (see note in first lines) that, if this section grows, it's HIGHLY
/// recommended to move all funcions below to a new "localib.php" file.


// zjištění statusu modelu studenta - asi z nějaké tabulky
function moodlekrem_get_status($gid, $cid, $uid) {
    // možné hodnoty statusu:
        // 0 - nesplněno
        // 1 - splněno
        // 2 - neznámo
    $status = 2;

    $type = 'sumcourse';
    $sql = "kremid='$gid' AND stype='$type' AND userid='$uid' AND shidden='0'";
    if (record_exists_select('moodlekrem_steps',$sql)) {
        $resource = get_record_select('moodlekrem_steps',$sql);
        $status = $resource->sstatus;
    }

    return $status;
}

//Vytvoření základního záznamu kurzu, s ID uživatele = 0
function moodlekrem_create_base_record($gid, $cid) {
    //global $CFG;
    $Return = 0;
    
    $table = 'moodlekrem_steps';
    $optable = 'moodlekrem_options';

    $rec = get_record($optable, 'gid', $gid, 'ptype', 'sumcourse');
    $modopt = $rec->modified;
    if (record_exists($table, 'kremid', $gid, 'userid', 0, 'stype', 'sumcourse')) {
        $rec = get_record($optable, 'gid', $gid, 'userid', 0, 'ptype', 'sumcourse');
        $modstep = $rec->modified;
    }
    if ($modopt > $modstep) {
        delete_records($table, 'kremid', $gid, 'userid', 0);
        $modstep = $modopt++;
        
        unset($step);
        $resources = get_records($optable, 'gid', $gid);
        
        foreach ($resources as $resource) {
            $step->kremid = $gid;
            $step->userid = 0;
            $step->courseid = $cid;
            $step->shidden = $resource->phidden;
            $step->stype = $resource->ptype;
            $step->skid = $resource->pid;
            $step->scode = $resource->pcode;
            $step->sname = $resource->pname;
            $step->sstatus = 0;
            $step->value = 0;
            $step->scriteria = $resource->pcriteria;
            $step->slimit = $resource->plimit;
            $step->params = $resource->pparams;
            $step->modified = $modstep;
            if ($step->shidden == 0) {
                $Return = insert_record($table,$step);
            }
        }
    }

    return $Return;
}

//Stanovení výsledné hodnoty kroku dle typu, kritéria a limitu
//Pro jednotlivé kroky
function moodlekrem_result_step($criteria, $value, $limit) {
    $result = false;

    switch ($criteria) {
        case 1: { if ($value > $limit) $result = true; break; }
        case 2: { if ($value < $limit) $result = true; break; }
        case 3: { if ($value >= $limit) $result = true; break; }
        case 4: { if ($value <= $limit) $result = true; break; }
        case 5: { if ($value == $limit) $result = true; break;  }
        case 6: { if ($value != $limit) $result = true; break; }
    }
    return $result;
}

//Stanovení výsledné hodnoty kroku dle typu, kritéria a limitu
//Pro celkové kroky
function moodlekrem_result_sum($criteria, $limit, $sumresource, $cntresource, $maxresource, $minresource) {
    $result = 0;
    $avgresource = $sumresource / $cntresource;

    switch ($criteria) {
        case 1: { if ($sumresource >= $limit) $result = $sumresource; break; }
        case 2: { if ($sumresource <= $limit) $result = $sumresource; break; }
        case 3: { if ($sumresource == $limit) $result = $sumresource; break; }
        case 4: { if ($cntresource >= $limit) $result = $cntresource; break; }
        case 5: { if ($cntresource <= $limit) $result = $cntresource; break; }
        case 6: { if ($cntresource == $limit) $result = $cntresource; break; }
        case 7: { if ($avgresource >= $limit) $result = $avgresource; break; }
        case 8: { if ($avgresource <= $limit) $result = $avgresource; break; }
        case 9: { if ($avgresource == $limit) $result = $avgresource; break; }
        case 10: { if ($maxresource >= $limit) $result = $maxresource; break; }
        case 11: { if ($maxresource <= $limit) $result = $maxresource; break; }
        case 12: { if ($maxresource == $limit) $result = $maxresource; break; }
        case 13: { if ($minresource >= $limit) $result = $minresource; break; }
        case 14: { if ($minresource <= $limit) $result = $minresource; break; }
        case 15: { if ($minresource == $limit) $result = $minresource; break; }
    }
    return $result;
}

//Vytvoření uživatelského záznamu kurzu, s ID uživatele = $uid
function moodlekrem_create_user_record($gid, $cid, $uid) {
    //global $CFG;
    $Return = 0;

    //Zjistit, zda je modul použit v Moodle ČZU
    $umoodle = get_record('course', 'id', 1);
    if ($umoodle->idnumber == 'CZU') {
        $czumood = true;
    } else {
        $czumood = false;
    }

    delete_records('moodlekrem_steps', 'kremid', $gid, 'userid', $uid);

    $cursum = 0;

    //studijní materiály - začátek
    unset($step);
    $type = 'resource';
    $sql = "kremid='$gid' AND stype='$type' AND userid='0' AND shidden='0' ORDER BY skid";
    $ress = count_records_select('moodlekrem_steps',$sql);
    $resources = get_records_select('moodlekrem_steps',$sql);
    
    $sumresource = 0;
    $cntresource = 0;
    $x = true;

    foreach ($resources as $resource) {
        $rid = $resource->skid;
        //pro Moodle ČZU čerpat z log_back jinak z log
        if ($czumood) {
            $recs = count_records('log_back', 'info', $rid, 'userid', $uid);
        } else {
            $recs = count_records('log', 'info', $rid, 'userid', $uid);
        }

        $step->sstatus = 0;
        $resresource = moodlekrem_result_step($resource->scriteria, $recs, $resource->slimit);
        if ($resresource) {
            $step->sstatus = 1;
            $cntresource++;
            $sumresource += $recs;
            if ($x) {
                $minresource = $recs;
                $maxresource = $recs;
                $x = false;
            } else {
                if ($recs > $maxresource) $maxresource = $recs;
                if ($recs < $minresource) $minresource = $recs;
            }
        }

        $step->kremid = $gid;
        $step->userid = $uid;
        $step->courseid = $cid;
        $step->params = $resource->params;
        $step->shidden = 0;
        $step->stype = $type;
        $step->scriteria = $resource->scriteria;
        $step->slimit = $resource->slimit;
        $step->skid = $rid;
        $step->scode = $resource->scode;
        $step->sname = $resource->sname;
        $step->svalue = $recs; //skutečnou hodnotu
        $Return = insert_record('moodlekrem_steps',$step);
    }
    //sumresources
    $type = 'sumresource';
    $sql = "kremid='$gid' AND stype='$type' AND userid='0' AND shidden='0'";
    $resources = get_record_select('moodlekrem_steps',$sql);
    
    $step->kremid = $gid;
    $step->userid = $uid;
    $step->courseid = $cid;
    $step->params = $resources->params;
    $step->shidden = 0;
    $step->stype = $type;
    $step->scriteria = $resources->scriteria;
    $step->slimit = $resources->slimit;
    $step->skid = 0;
    $step->scode = $resources->scode;
    $step->sname = $resources->sname;
    $step->sstatus = 0;

    $resresource = moodlekrem_result_sum($resources->scriteria, $resources->slimit, $sumresource, $cntresource, $maxresource, $minresource);
    if ($resresource > 0) {
        $cursum++;
        $step->sstatus = 1;
    }

    $step->svalue = $resresource; //skutečnou hodnotu
    $Return = insert_record('moodlekrem_steps',$step);
    //studijní materiály - konec

    //dochazka - začátek
    $type = 'attendance';
    $sql = "kremid='$gid' AND stype='$type' AND userid='0' AND shidden='0' ORDER BY skid";
    $ress = count_records_select('moodlekrem_steps',$sql);
    $resources = get_records_select('moodlekrem_steps',$sql);

    $sumresource = 0;
    $cntresource = 0;
    $x = true;

    foreach ($resources as $resource) {
        $rid = $resource->skid;
        $statusid = get_record('attendance_log','sessionid',$rid,'studentid',$uid);
        $grades = get_record('attendance_statuses','id',$statusid->statusid);
        $recs = $grades->grade;
        $step->sstatus = 0;

        $resresource = moodlekrem_result_step($resource->scriteria, $recs, $resource->slimit);
        if ($resresource) {
            $step->sstatus = 1;
            $cntresource++;
            $sumresource += $recs;
            if ($x) {
                $minresource = $recs;
                $maxresource = $recs;
                $x = false;
            } else {
                if ($recs > $maxresource) $maxresource = $recs;
                if ($recs < $minresource) $minresource = $recs;
            }
        }
        
        $step->kremid = $gid;
        $step->userid = $uid;
        $step->courseid = $cid;
        $step->params = $resource->params;
        $step->shidden = 0;
        $step->stype = $type;
        $step->scriteria = $resource->scriteria;
        $step->slimit = $resource->slimit;
        $step->skid = $rid;
        $step->scode = $resource->scode;
        $step->sname = $resource->sname;
        $step->svalue = $recs; //skutečnou hodnotu
        $Return = insert_record('moodlekrem_steps',$step);
        
    }
    
    //sumattendance
    $type = 'sumattendance';
    $sql = "kremid='$gid' AND stype='$type' AND userid='0' AND shidden='0'";
    $resources = get_record_select('moodlekrem_steps',$sql);
    
    $step->kremid = $gid;
    $step->userid = $uid;
    $step->courseid = $cid;
    $step->params = $resources->params;
    $step->shidden = 0;
    $step->stype = $type;
    $step->scriteria = $resources->scriteria;
    $step->slimit = $resources->slimit;
    $step->skid = 0;
    $step->scode = $resources->scode;
    $step->sname = $resources->sname;
    $step->sstatus = 0;
    
    $resresource = moodlekrem_result_sum($resources->scriteria, $resources->slimit, $sumresource, $cntresource, $maxresource, $minresource);
    if ($resresource > 0) {
        $cursum++;
        $step->sstatus = 1;
    }

    $step->svalue = $resresource; //skutečnou hodnotu
    $Return = insert_record('moodlekrem_steps',$step);
    //dochazka - konec

    //testy - začátek
    $type = 'quiz';
    $sql = "kremid='$gid' AND stype='$type' AND userid='0' AND shidden='0' ORDER BY skid";
    $ress = count_records_select('moodlekrem_steps',$sql);
    $resources = get_records_select('moodlekrem_steps',$sql);

    $sumresource = 0;
    $cntresource = 0;
    $x = true;

    foreach ($resources as $resource) {
        $rid = $resource->skid;
        $grades = get_record('quiz_grades','quiz',$rid,'userid',$uid);
        $recs = $grades->grade;
        $step->sstatus = 0;

        $resresource = moodlekrem_result_step($resource->scriteria, $recs, $resource->slimit);
        if ($resresource) {
            $step->sstatus = 1;
            $cntresource++;
            $sumresource += $recs;
            if ($x) {
                $minresource = $recs;
                $maxresource = $recs;
                $x = false;
            } else {
                if ($recs > $maxresource) $maxresource = $recs;
                if ($recs < $minresource) $minresource = $recs;
            }
        }
        
        $step->kremid = $gid;
        $step->userid = $uid;
        $step->courseid = $cid;
        $step->params = $resource->params;
        $step->shidden = 0;
        $step->stype = $type;
        $step->scriteria = $resource->scriteria;
        $step->slimit = $resource->slimit;
        $step->skid = $rid;
        $step->scode = $resource->scode;
        $step->sname = $resource->sname;
        $step->svalue = $recs; //skutečnou hodnotu
        $Return = insert_record('moodlekrem_steps',$step);
    }

    //sumquiz
    $type = 'sumquiz';
    $sql = "kremid='$gid' AND stype='$type' AND userid='0' AND shidden='0'";
    $resources = get_record_select('moodlekrem_steps',$sql);
    
    $step->kremid = $gid;
    $step->userid = $uid;
    $step->courseid = $cid;
    $step->params = $resources->params;
    $step->shidden = 0;
    $step->stype = $type;
    $step->scriteria = $resources->scriteria;
    $step->slimit = $resources->slimit;
    $step->skid = 0;
    $step->scode = $resources->scode;
    $step->sname = $resources->sname;
    $step->sstatus = 0;
    
    $resresource = moodlekrem_result_sum($resources->scriteria, $resources->slimit, $sumresource, $cntresource, $maxresource, $minresource);
    if ($resresource > 0) {
        $cursum++;
        $step->sstatus = 1;
    }

    $step->svalue = $resresource; //skutečnou hodnotu
    $Return = insert_record('moodlekrem_steps',$step);
    //testy - konec

    //kurz - začátek
    //sumcourse
    $type = 'sumcourse';
    $sql = "kremid='$gid' AND stype='$type' AND userid='0' AND shidden='0'";
    $resources = get_record_select('moodlekrem_steps',$sql);

    $step->sstatus = 0;

    $resresource = moodlekrem_result_step($resources->scriteria, $cursum, $resources->slimit);
    if ($resresource) {
        $step->sstatus = 1;
    }

    $step->kremid = $gid;
    $step->userid = $uid;
    $step->courseid = $cid;
    $step->params = $resources->params;
    $step->shidden = 0;
    $step->stype = $type;
    $step->scriteria = $resources->scriteria;
    $step->slimit = $resources->slimit;
    $step->skid = 0;
    $step->scode = $resources->scode;
    $step->sname = $resources->sname;
    $step->svalue = $cursum; //skutečnou hodnotu
    $Return = insert_record('moodlekrem_steps',$step);
    
    // kurz - konec

    return $Return;
}

// Zobrazí model jednoho studenta
// parametry:
//      $gid    glikrem ID
//      $cid    course ID
//      $uid    user ID (student)
function moodlekrem_showmodel($gid,$cid,$uid) {
    global $CFG;

    $moodlekrem = get_record('moodlekrem', 'id', $gid);
    $course = get_record('course', 'id', $moodlekrem->course);
    $cm = get_coursemodule_from_instance('moodlekrem', $moodlekrem->id, $course->id);
    $user = get_record('user', 'id', $uid);

    $user->fullname = $user->lastname." ".$user->firstname;

    add_to_log($course->id, "moodlekrem", "view", "view.php?id=$cm->id", "$moodlekrem->id");

    /// Print the page header
    $strmoodlekrems = get_string('modulenameplural', 'moodlekrem');
    $strmoodlekrem  = get_string('modulename', 'moodlekrem');

    $navlinks = array();
    $navlinks[] = array('name' => $strmoodlekrems, 'link' => "index.php?id=$course->id", 'type' => 'activity');
    $navlinks[] = array('name' => format_string($moodlekrem->name), 'link' => "view.php?id=$cm->id", 'type' => 'activityinstance');
    $navlinks[] = array('name' => $strmoodlekrem." - ".$user->fullname, 'link' => '', 'type' => 'title');

    $navigation = build_navigation($navlinks);

    print_header_simple(format_string($moodlekrem->name), '', $navigation, '', '', true, '', navmenu($course, $cm));

    /// Print the main part of the page

    //Vytvoření záznamu uživatele
    moodlekrem_create_base_record($gid, $cid);
    moodlekrem_create_user_record($gid, $cid, $uid);

    print_heading(get_string('moodlekremshowname', 'moodlekrem'));

    //print user info
    print_box_start();
    $picture = print_user_picture($user, $course->id, $user->picture, false, true);
    $userlink = ' <a href="'.$CFG->wwwroot.'/user/view.php?id='.$user->id.'&amp;course='.$course->id.'">'.$user->fullname.'</a>';
    echo "<i>".get_string('moodlekremuserid', 'moodlekrem').":</i><br><br>";
    echo "<b>".$picture.$userlink."</b><br>";
    print_box_end();

    //parametres
    $type = 'resource';
    $sql = "kremid='$gid' AND stype='$type' AND userid='$uid' AND shidden='0' ORDER BY skid";
    $c_res = count_records_select('moodlekrem_steps',$sql);
    $type = 'attendance';
    $sql = "kremid='$gid' AND stype='$type' AND userid='$uid' AND shidden='0' ORDER BY skid";
    $c_att = count_records_select('moodlekrem_steps',$sql);
    $type = 'quiz';
    $sql = "kremid='$gid' AND stype='$type' AND userid='$uid' AND shidden='0' ORDER BY skid";
    $c_qui = count_records_select('moodlekrem_steps',$sql);

    $c_cou = $c_res + $c_att + $c_qui;

    //**************************  GLIKREM - grafický  ***************************
    $bg_yellow = ' bgcolor="#FFFF80" align="center"';
    $bg_brown = ' bgcolor="#996633" align="center"';
    $bg_green = ' bgcolor="#33CC66" align="center"';
    $bg_blue = ' bgcolor="#99FFFF" align="center"';
    $bg_grey = ' bgcolor="#CCCCCC" align="center"';

    $img_branch = '<img src="branch.gif">&nbsp;';
    $img_synchro = '<img src="synchro.gif">&nbsp;';
    $img_action = '<img src="action.gif">&nbsp;';
    $img_state = '<img src="state.gif">&nbsp;';
    $img_case = '<img src="case.gif">';

    print_box_start();
    echo "<i>".get_string('moodlekremshowname', 'moodlekrem').":</i><br><br>";

    echo '<table border=1 cellpadding=10 cellspacing=10>';
    echo '<tr><td colspan='.$c_cou.$bg_yellow.'>'.$img_state.get_string('moodlekremstart', 'moodlekrem').'&nbsp;</td></tr>';
    echo '<tr>';
    echo '<td colspan='.$c_res.$bg_brown.'>'.$img_branch.get_string('modulenameplural', 'resource').'&nbsp;</td>';
    echo '<td colspan='.$c_att.$bg_brown.'>'.$img_branch.get_string('modulenameplural', 'attendance').'&nbsp;</td>';
    echo '<td colspan='.$c_qui.$bg_brown.'>'.$img_branch.get_string('modulenameplural', 'quiz').'&nbsp;</td>';
    echo '</tr>';

    $type = 'resource';
    $sql = "kremid='$gid' AND stype='$type' AND userid='$uid' AND shidden='0' ORDER BY skid";
    $resources = get_records_select('moodlekrem_steps',$sql);

    $type = 'attendance';
    $sql = "kremid='$gid' AND stype='$type' AND userid='$uid' AND shidden='0' ORDER BY skid";
    $attendances = get_records_select('moodlekrem_steps',$sql);

    $type = 'quiz';
    $sql = "kremid='$gid' AND stype='$type' AND userid='$uid' AND shidden='0' ORDER BY skid";
    $quizes = get_records_select('moodlekrem_steps',$sql);

    echo '<tr>';
    foreach ($resources as $resource) {
        $code = $resource->scode;
        echo '<td'.$bg_green.'>'.$img_action.$code.'&nbsp;</td>';
    }
    foreach ($attendances as $attendance) {
        $code = $attendance->scode;
        echo '<td'.$bg_green.'>'.$img_action.$code.'&nbsp;</td>';
    }
    foreach ($quizes as $quiz) {
        $code = $quiz->scode;
        echo '<td'.$bg_green.'>'.$img_action.$code.'&nbsp;</td>';
    }
    echo '</tr>';

    echo '<tr>';
    foreach ($resources as $resource) {
        $code = $resource->scode;
        echo '<td'.$bg_blue.'>'.$img_case.'</td>';
    }
    foreach ($attendances as $attendance) {
        $code = $attendance->scode;
        echo '<td'.$bg_blue.'>'.$img_case.'</td>';
    }
    foreach ($quizes as $quiz) {
        $code = $quiz->scode;
        echo '<td'.$bg_blue.'>'.$img_case.'</td>';
    }
    echo '</tr>';

    echo '<tr>';
    foreach ($resources as $resource) {
        if ($resource->sstatus == 1) {
            echo '<td'.$bg_yellow.'>'.$img_state.get_string('yes', 'moodle').'&nbsp;</td>';
        } else {
            echo '<td'.$bg_grey.'>'.$img_state.get_string('no', 'moodle').'&nbsp;</td>';
        }
    }
    foreach ($attendances as $attendance) {
        if ($attendance->sstatus == 1) {
            echo '<td'.$bg_yellow.'>'.$img_state.get_string('yes', 'moodle').'&nbsp;</td>';
        } else {
            echo '<td'.$bg_grey.'>'.$img_state.get_string('no', 'moodle').'&nbsp;</td>';
        }
    }
    foreach ($quizes as $quiz) {
        if ($quiz->sstatus == 1) {
            echo '<td'.$bg_yellow.'>'.$img_state.get_string('yes', 'moodle').'&nbsp;</td>';
        } else {
            echo '<td'.$bg_grey.'>'.$img_state.get_string('no', 'moodle').'&nbsp;</td>';
        }
    }
    echo '</tr>';

    $sql = "kremid='$gid' AND stype='sumresource' AND userid='$uid' AND shidden='0'";
    $sumresource = get_record_select('moodlekrem_steps',$sql);

    $type = 'sumattendance';
    $sql = "kremid='$gid' AND stype='$type' AND userid='$uid' AND shidden='0'";
    $sumattendance = get_record_select('moodlekrem_steps',$sql);

    $type = 'sumquiz';
    $sql = "kremid='$gid' AND stype='$type' AND userid='$uid' AND shidden='0'";
    $sumquiz = get_record_select('moodlekrem_steps',$sql);

    echo '<tr>';
    echo '<td colspan='.$c_res.$bg_brown.'>'.$img_synchro.$sumresource->sname.'&nbsp;</td>';
    echo '<td colspan='.$c_att.$bg_brown.'>'.$img_synchro.$sumattendance->sname.'&nbsp;</td>';
    echo '<td colspan='.$c_qui.$bg_brown.'>'.$img_synchro.$sumquiz->sname.'&nbsp;</td>';
    echo '</tr>';

    echo '<tr>';
    echo '<td colspan='.$c_res.$bg_blue.'>'.$img_case.'</td>';
    echo '<td colspan='.$c_att.$bg_blue.'>'.$img_case.'</td>';
    echo '<td colspan='.$c_qui.$bg_blue.'>'.$img_case.'</td>';
    echo '</tr>';

    echo '<tr>';
    if ($sumresource->sstatus == 1) {
        echo '<td colspan='.$c_res.$bg_yellow.'>'.$img_state.get_string('yes', 'moodle').'&nbsp;</td>';
    } else {
        echo '<td colspan='.$c_res.$bg_grey.'>'.$img_state.get_string('no', 'moodle').'&nbsp;</td>';
    }
    if ($sumattendance->sstatus == 1) {
        echo '<td colspan='.$c_att.$bg_yellow.'>'.$img_state.get_string('yes', 'moodle').'&nbsp;</td>';
    } else {
        echo '<td colspan='.$c_att.$bg_grey.'>'.$img_state.get_string('no', 'moodle').'&nbsp;</td>';
    }
    if ($sumquiz->sstatus == 1) {
        echo '<td colspan='.$c_qui.$bg_yellow.'>'.$img_state.get_string('yes', 'moodle').'&nbsp;</td>';
    } else {
        echo '<td colspan='.$c_qui.$bg_grey.'>'.$img_state.get_string('no', 'moodle').'&nbsp;</td>';
    }
    echo '</tr>';

    $type = 'sumcourse';
    $sql = "kremid='$gid' AND stype='$type' AND userid='$uid' AND shidden='0'";
    $sumcourse = get_record_select('moodlekrem_steps',$sql);

    echo '<tr><td colspan='.$c_cou.$bg_brown.'>'.$img_synchro.$sumcourse->sname.'&nbsp;</td></tr>';
    echo '<tr><td colspan='.$c_cou.$bg_blue.'>'.$img_case.'</td></tr>';

    echo '<tr>';
    if ($sumcourse->sstatus == 1) {
        echo '<td colspan='.$c_cou.$bg_yellow.'>'.$img_state.get_string('yes', 'moodle').'&nbsp;</td>';
    } else {
        echo '<td colspan='.$c_cou.$bg_grey.'>'.$img_state.get_string('no', 'moodle').'&nbsp;</td>';
    }
    echo '</tr>';

    echo '</table>';
    print_box_end();

    //********************** PODROBNOSTI ****************************
    //resources
    print_box_start();
    $type = 'resource';
    $sql = "kremid='$gid' AND stype='$type' AND userid='$uid' AND shidden='0' ORDER BY skid";
    echo "<i>".get_string('modulenameplural', 'resource').":</i><br><br>";
    $resources = get_records_select('moodlekrem_steps',$sql);
    foreach ($resources as $resource) {
        $rcode = $resource->scode;
        $recs = $resource->svalue;
        $limit = $resource->slimit;
        if ($resource->sstatus == 1) {
            $read = "<font color=green>".get_string('yes', 'moodle')."</font>";
        } else {
            $read = "<font color=red>".get_string('no', 'moodle')."</font>";
        }
        echo $read." -> (".$rcode.") ".$resource->sname."<br>";
    }

    $sql = "kremid='$gid' AND stype='sumresource' AND userid='$uid' AND shidden='0'";
    $resource = get_record_select('moodlekrem_steps',$sql);
    if ($resource->sstatus == 1) {
        $read = "<font color=green>".get_string('yes', 'moodle')."</font>";
    } else {
        $read = "<font color=red>".get_string('no', 'moodle')."</font>";
    }
    echo "<br><b>".$read." -> ".$resource->sname."</b>";
    print_box_end();

    //dochazka - začátek
    print_box_start();
    $type = 'attendance';
    $sql = "kremid='$gid' AND stype='$type' AND userid='$uid' AND shidden='0' ORDER BY skid";
    echo "<i>".get_string('modulenameplural', 'attendance').":</i><br><br>";
    $resources = get_records_select('moodlekrem_steps',$sql);
    foreach ($resources as $resource) {
        $rcode = $resource->scode;
        $recs = $resource->svalue;
        $limit = $resource->slimit;
        if ($resource->sstatus == 1) {
            $read = "<font color=green>".get_string('yes', 'moodle')."</font>";
        } else {
            $read = "<font color=red>".get_string('no', 'moodle')."</font>";
        }
        echo $read." -> (".$rcode.") ".$resource->sname."<br>";
    }

    $type = 'sumattendance';
    $sql = "kremid='$gid' AND stype='$type' AND userid='$uid' AND shidden='0'";
    $resource = get_record_select('moodlekrem_steps',$sql);
    if ($resource->sstatus == 1) {
        $read = "<font color=green>".get_string('yes', 'moodle')."</font>";
    } else {
        $read = "<font color=red>".get_string('no', 'moodle')."</font>";
    }
    $c_attg = $c_att*2;
    echo "<br><b>".$read." -> ".$resource->sname."</b>";
    print_box_end();

    //testy - začátek
    print_box_start();
    $type = 'quiz';
    $sql = "kremid='$gid' AND stype='$type' AND userid='$uid' AND shidden='0' ORDER BY skid";
    echo "<i>".get_string('modulenameplural', 'quiz').":</i><br><br>";
    $resources = get_records_select('moodlekrem_steps',$sql);
    foreach ($resources as $resource) {
        $rcode = $resource->scode;
        $recs = $resource->svalue;
        $limit = $resource->slimit;
        if ($resource->sstatus == 1) {
            $read = "<font color=green>".get_string('yes', 'moodle')."</font>";
        } else {
            $read = "<font color=red>".get_string('no', 'moodle')."</font>";
        }
        echo $read." -> (".$rcode.") ".$resource->sname."<br>";
    }

    $type = 'sumquiz';
    $sql = "kremid='$gid' AND stype='$type' AND userid='$uid' AND shidden='0'";
    $resource = get_record_select('moodlekrem_steps',$sql);
    if ($resource->sstatus == 1) {
        $read = "<font color=green>".get_string('yes', 'moodle')."</font>";
    } else {
        $read = "<font color=red>".get_string('no', 'moodle')."</font>";
    }
    echo "<br><b>".$read." -> ".$resource->sname."</b>";
    print_box_end();

    // print course
    print_box_start();
    echo "<i>".get_string('course', 'moodle').":</i><br>";
    $type = 'sumcourse';
    $sql = "kremid='$gid' AND stype='$type' AND userid='$uid' AND shidden='0'";
    $resource = get_record_select('moodlekrem_steps',$sql);
    if ($resource->sstatus == 1) {
        $read = "<font color=green>".get_string('yes', 'moodle')."</font>";
    } else {
        $read = "<font color=red>".get_string('no', 'moodle')."</font>";
    }
    echo "<br><b>".$read." -> ".$resource->sname."</b>";
    print_box_end();

    //paticka
    print_footer('empty');
    echo '</br>';

    return true;
}
?>
