<?php

require_once(dirname(dirname(dirname(__FILE__))).'/config.php');
require_once(dirname(__FILE__).'/lib.php');

$id = optional_param('id', 0, PARAM_INT);
$gid = optional_param('gid', 0, PARAM_INT);
$cid  = optional_param('cid', 0, PARAM_INT);
$uid  = optional_param('uid', 0, PARAM_INT);

if ($id) {
    if (! $cm = get_coursemodule_from_id('moodlekrem', $id)) {
        error('Course Module ID was incorrect');
    }

    if (! $course = get_record('course', 'id', $cm->course)) {
        error('Course is misconfigured');
    }

    if (! $moodlekrem = get_record('moodlekrem', 'id', $cm->instance)) {
        error('Course module is incorrect');
    }

} else if ($gid) {
    if (! $moodlekrem = get_record('moodlekrem', 'id', $gid)) {
        error('Course module is incorrect');
    }
    if (! $course = get_record('course', 'id', $moodlekrem->course)) {
        error('Course is misconfigured');
    }
    if (! $cm = get_coursemodule_from_instance('moodlekrem', $moodlekrem->id, $course->id)) {
        error('Course Module ID was incorrect');
    }

} else {
    error('You must specify a course_module ID or an instance ID');
}

require_login($course, true, $cm);

if ($uid) {
    if (! $user = get_record('user', 'id', $uid)) {
        error('User ID was incorrect');
    }
} else if ($USER->id) {
    if (! $user = get_record('user', 'id', $USER->id)) {
        error('User ID was incorrect');
    }
} else error('User ID was incorrect');

$gid = $moodlekrem->id;
$cid = $course->id;
$uid = $user->id;

moodlekrem_showmodel($gid,$cid,$uid);

?>
