<?php //$Id: mod_form.php,v 1.2.2.3 2009/03/19 12:23:11 mudrd8mz Exp $

/**
 * This file defines the main moodlekrem configuration form
 * It uses the standard core Moodle (>1.8) formslib. For
 * more info about them, please visit:
 *
 * http://docs.moodle.org/en/Development:lib/formslib.php
 *
 * The form must provide support for, at least these fields:
 *   - name: text element of 64cc max
 *
 * Also, it's usual to use these fields:
 *   - intro: one htmlarea element to describe the activity
 *            (will be showed in the list of activities of
 *             moodlekrem type (index.php) and in the header
 *             of the moodlekrem main page (view.php).
 *   - introformat: The format used to write the contents
 *             of the intro field. It automatically defaults
 *             to HTML when the htmleditor is used and can be
 *             manually selected if the htmleditor is not used
 *             (standard formats are: MOODLE, HTML, PLAIN, MARKDOWN)
 *             See lib/weblib.php Constants and the format_text()
 *             function for more info
 */

require_once($CFG->dirroot.'/course/moodleform_mod.php');
require_once(dirname(dirname(dirname(__FILE__))).'/config.php');
require_once(dirname(__FILE__).'/lib.php');

class mod_moodlekrem_mod_form extends moodleform_mod {

    function definition() {

        global $CFG;
        global $COURSE;
        $mform =& $this->_form;

//-------------------------------------------------------------------------------
    /// Adding the "general" fieldset, where all the common settings are showed
        $mform->addElement('header', 'general', get_string('general', 'form'));

    /// Adding the standard "name" field
        $mform->addElement('text', 'name', get_string('moodlekremname', 'moodlekrem'), array('size'=>'64'));
        $mform->setType('name', PARAM_TEXT);
        $mform->addRule('name', null, 'required', null, 'client');
        $mform->addRule('name', get_string('maximumchars', '', 255), 'maxlength', 255, 'client');

    /// Adding the required "intro" field to hold the description of the instance
        $mform->addElement('htmleditor', 'intro', get_string('moodlekremintro', 'moodlekrem'));
        $mform->setType('intro', PARAM_RAW);
        $mform->addRule('intro', get_string('required'), 'required', null, 'client');
        $mform->setHelpButton('intro', array('writing', 'richtext'), false, 'editorhelpbutton');

    /// Adding "introformat" field
        $mform->addElement('format', 'introformat', get_string('format'));

//-------------------------------------------------------------------------------
    /// Adding the rest of moodlekrem settings, spreeading all them into this fieldset
    /// or adding more fieldsets ('header' elements) if needed for better logic
        $cid = $COURSE->id;
        $gid = (int)$this->_instance;
        
        $optable = 'moodlekrem_options';

        $rescrit = array();
        $rescrit[1] = '>'; $rescrit[2] = '<'; $rescrit[3] = '>=';
        $rescrit[4] = '<='; $rescrit[5] = '='; $rescrit[6] = '!=';


        $sumrescrit = array();
        $sumrescrit[1] = get_string('moodlekremcritsuma', 'moodlekrem').' >=';
        $sumrescrit[2] = get_string('moodlekremcritsuma', 'moodlekrem').' <=';
        $sumrescrit[3] = get_string('moodlekremcritsuma', 'moodlekrem').' =';
        $sumrescrit[4] = get_string('moodlekremcritcount', 'moodlekrem').' >=';
        $sumrescrit[5] = get_string('moodlekremcritcount', 'moodlekrem').' <=';
        $sumrescrit[6] = get_string('moodlekremcritcount', 'moodlekrem').' =';
        $sumrescrit[7] = get_string('moodlekremcritavg', 'moodlekrem').' >=';
        $sumrescrit[8] = get_string('moodlekremcritavg', 'moodlekrem').' <=';
        $sumrescrit[9] = get_string('moodlekremcritavg', 'moodlekrem').' =';
        $sumrescrit[10] = get_string('moodlekremcritmax', 'moodlekrem').' >=';
        $sumrescrit[11] = get_string('moodlekremcritmax', 'moodlekrem').' <=';
        $sumrescrit[12] = get_string('moodlekremcritmax', 'moodlekrem').' =';
        $sumrescrit[13] = get_string('moodlekremcritmin', 'moodlekrem').' >=';
        $sumrescrit[14] = get_string('moodlekremcritmin', 'moodlekrem').' <=';
        $sumrescrit[15] = get_string('moodlekremcritmin', 'moodlekrem').' =';

        $currescrit = array();
        $currescrit[1] = get_string('moodlekremcritcount', 'moodlekrem').' >';
        $currescrit[2] = get_string('moodlekremcritcount', 'moodlekrem').' <';
        $currescrit[3] = get_string('moodlekremcritcount', 'moodlekrem').' >=';
        $currescrit[4] = get_string('moodlekremcritcount', 'moodlekrem').' <=';
        $currescrit[5] = get_string('moodlekremcritcount', 'moodlekrem').' =';
        $currescrit[6] = get_string('moodlekremcritcount', 'moodlekrem').' !=';

        // Studijní materiály
        $mform->addElement('header', 'moodlekremresource', get_string('modulenameplural', 'resource'));
        unset($step);
        $type = 'resource';
        $code = 'R';
        $limit = 1;
        $resources = get_records($type, 'course', $cid);
        $i = 1;
        foreach ($resources as $resource) {
            $step->slimit = $limit;
            $step->scode = $code.$i;
            $step->sname = $resource->name;
            $step->params = '';
            $mform->addElement('static', 'X'.$step->scode, $i.'.'.get_string('modulename', 'resource').' ->&nbsp;', '<b>'.$step->sname.'</b>');
            $mform->addElement('hidden', 'N'.$step->scode, $step->sname);
            $group=array();
            $group[] = &$mform->createElement('checkbox', 'H'.$step->scode, ' ', get_string('moodlekremhidden', 'moodlekrem').'? ... '.get_string('moodlekremcode', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', $step->scode);
            $group[] = &$mform->createElement('static', 'krit', ' ' ,' ... '.get_string('moodlekremcrit', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('select', 'C'.$step->scode, ' ', $rescrit);
            $group[] = &$mform->createElement('static', 'val', ' ' ,' '.get_string('moodlekremlimit', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', 'L'.$step->scode);
            $group[] = &$mform->createElement('static', 'parametry', ' ', ' ... '.get_string('moodlekremparams', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', 'P'.$step->scode);
            $mform->addGroup($group, $type.'grp'.$i, ' ', null, false);
            $mform->addElement('hidden', 'I'.$step->scode, $resource->id);
            if ($option = get_record($optable, 'gid', $gid, 'ptype', $type, 'pid', $resource->id)) {
                $mform->setDefault($step->scode, $option->pcode);
                $mform->setDefault('L'.$step->scode, $option->plimit);
                $mform->setDefault('P'.$step->scode, $option->pparams);
                $mform->setDefault('C'.$step->scode, $option->pcriteria);
                if ($option->phidden == 1) {
                    $mform->setDefault('H'.$step->scode, 'checked');
                }
            } else {
                $mform->setDefault($step->scode, $step->scode);
                $mform->setDefault('L'.$step->scode, $step->slimit);
                $mform->setDefault('P'.$step->scode, $step->params);
                $mform->setDefault('C'.$step->scode, 3);
            }
            $i++;
        }
        $mform->addElement('static', 'line', ' ', '***********************************************');
        
        $type = 'sumresource';
        $code = 'SUM_R';
        $limit = $i-1;
        $step->slimit = $limit;
        $step->scode = $code;
        $step->sname = get_string('modulenameplural', 'resource').' - '.get_string('moodlekremsuma', 'moodlekrem');
        $step->params = '';
        $mform->addElement('static', 'X'.$step->scode, '', '<b>'.$step->sname.'</b>');
        $mform->addElement('hidden', 'N'.$step->scode, $step->sname);
        $group=array();
        $group[] = &$mform->createElement('checkbox', 'H'.$step->scode, ' ', get_string('moodlekremhidden', 'moodlekrem').'? ... '.get_string('moodlekremcode', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', $step->scode);
            $group[] = &$mform->createElement('static', 'krit', ' ' ,' ... '.get_string('moodlekremcrit', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('select', 'C'.$step->scode, ' ', $sumrescrit);
            $group[] = &$mform->createElement('static', 'val', ' ' ,' '.get_string('moodlekremlimit', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', 'L'.$step->scode);
            $group[] = &$mform->createElement('static', 'parametry', ' ', ' ... '.get_string('moodlekremparams', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', 'P'.$step->scode);
        $mform->addGroup($group, $type.'grp', ' ', null, false);
        if ($option = get_record($optable, 'gid', $gid, 'ptype', $type)) {
                $mform->setDefault($step->scode, $option->pcode);
                $mform->setDefault('L'.$step->scode, $option->plimit);
                $mform->setDefault('P'.$step->scode, $option->pparams);
                $mform->setDefault('C'.$step->scode, $option->pcriteria);
                if ($option->phidden == 1) {
                    $mform->setDefault('H'.$step->scode, 'checked');
                }
        } else {
                $mform->setDefault($step->scode, $step->scode);
                $mform->setDefault('L'.$step->scode, $step->slimit);
                $mform->setDefault('P'.$step->scode, $step->params);
                $mform->setDefault('C'.$step->scode, 4);
        }

        // Docházka
        $mform->addElement('header', 'moodlekremattendance', get_string('modulenameplural', 'attendance'));
        unset($step);
        $type = 'attendance';
        $code = 'A';
        $limit = 1;
        $resources = get_records('attendance_sessions', 'courseid', $cid);
        $i = 1;
        foreach ($resources as $resource) {
            $step->slimit = $limit;
            $step->scode = $code.$i;
            $step->sname = $resource->description;
            $step->params = '';
            $mform->addElement('static', 'X'.$step->scode, $i.'.'.get_string('modulename', 'attendance').' ->&nbsp;', '<b>'.$step->sname.'</b>');
            $mform->addElement('hidden', 'N'.$step->scode, $step->sname);
            $group=array();
            $group[] = &$mform->createElement('checkbox', 'H'.$step->scode, ' ', get_string('moodlekremhidden', 'moodlekrem').'? ... '.get_string('moodlekremcode', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', $step->scode);
            $group[] = &$mform->createElement('static', 'krit', ' ' ,' ... '.get_string('moodlekremcrit', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('select', 'C'.$step->scode, ' ', $rescrit);
            $group[] = &$mform->createElement('static', 'val', ' ' ,' '.get_string('moodlekremlimit', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', 'L'.$step->scode);
            $group[] = &$mform->createElement('static', 'parametry', ' ', ' ... '.get_string('moodlekremparams', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', 'P'.$step->scode);
            $mform->addGroup($group, $type.'grp'.$i, ' ', null, false);
            $mform->addElement('hidden', 'I'.$step->scode, $resource->id);
            if ($option = get_record($optable, 'gid', $gid, 'ptype', $type, 'pid', $resource->id)) {
                $mform->setDefault($step->scode, $option->pcode);
                $mform->setDefault('L'.$step->scode, $option->plimit);
                $mform->setDefault('P'.$step->scode, $option->pparams);
                $mform->setDefault('C'.$step->scode, $option->pcriteria);
                if ($option->phidden == 1) {
                    $mform->setDefault('H'.$step->scode, 'checked');
                }
            } else {
                $mform->setDefault($step->scode, $step->scode);
                $mform->setDefault('L'.$step->scode, $step->slimit);
                $mform->setDefault('P'.$step->scode, $step->params);
                $mform->setDefault('C'.$step->scode, 3);
            }
            $i++;
        }
        $mform->addElement('static', 'line', ' ', '***********************************************');

        $type = 'sumattendance';
        $code = 'SUM_A';
        $limit = $i-1;
        $step->slimit = $limit;
        $step->scode = $code;
        $step->sname = get_string('modulenameplural', 'attendance').' - '.get_string('moodlekremsuma', 'moodlekrem');
        $step->params = '';
        $mform->addElement('static', 'X'.$step->scode, '', '<b>'.$step->sname.'</b>');
        $mform->addElement('hidden', 'N'.$step->scode, $step->sname);
        $group=array();
        $group[] = &$mform->createElement('checkbox', 'H'.$step->scode, ' ', get_string('moodlekremhidden', 'moodlekrem').'? ... '.get_string('moodlekremcode', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', $step->scode);
            $group[] = &$mform->createElement('static', 'krit', ' ' ,' ... '.get_string('moodlekremcrit', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('select', 'C'.$step->scode, ' ', $sumrescrit);
            $group[] = &$mform->createElement('static', 'val', ' ' ,' '.get_string('moodlekremlimit', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', 'L'.$step->scode);
            $group[] = &$mform->createElement('static', 'parametry', ' ', ' ... '.get_string('moodlekremparams', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', 'P'.$step->scode);
        $mform->addGroup($group, $type.'grp', ' ', null, false);
        if ($option = get_record($optable, 'gid', $gid, 'ptype', $type)) {
                $mform->setDefault($step->scode, $option->pcode);
                $mform->setDefault('L'.$step->scode, $option->plimit);
                $mform->setDefault('P'.$step->scode, $option->pparams);
                $mform->setDefault('C'.$step->scode, $option->pcriteria);
                if ($option->phidden == 1) {
                    $mform->setDefault('H'.$step->scode, 'checked');
                }
        } else {
            $mform->setDefault($step->scode, $step->scode);
            $mform->setDefault('L'.$step->scode, $step->slimit);
            $mform->setDefault('P'.$step->scode, $step->params);
            $mform->setDefault('C'.$step->scode, 1);
        }

        // Testy
        $mform->addElement('header', 'moodlekremquiz', get_string('modulenameplural', 'quiz'));
        unset($step);
        $type = 'quiz';
        $code = 'Q';
        $limit = 1;
        $resources = get_records($type, 'course', $cid);
        $i = 1;
        foreach ($resources as $resource) {
            $step->slimit = $limit;
            $step->scode = $code.$i;
            $step->sname = $resource->name;
            $step->params = '';
            $mform->addElement('static', 'X'.$step->scode, $i.'.'.get_string('modulename', 'quiz').' ->&nbsp;', '<b>'.$step->sname.'</b>');
            $mform->addElement('hidden', 'N'.$step->scode, $step->sname);
            $group=array();
            $group[] = &$mform->createElement('checkbox', 'H'.$step->scode, ' ', get_string('moodlekremhidden', 'moodlekrem').'? ... '.get_string('moodlekremcode', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', $step->scode);
            $group[] = &$mform->createElement('static', 'krit', ' ' ,' ... '.get_string('moodlekremcrit', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('select', 'C'.$step->scode, ' ', $rescrit);
            $group[] = &$mform->createElement('static', 'val', ' ' ,' '.get_string('moodlekremlimit', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', 'L'.$step->scode);
            $group[] = &$mform->createElement('static', 'parametry', ' ', ' ... '.get_string('moodlekremparams', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', 'P'.$step->scode);
            $mform->addGroup($group, $type.'grp'.$i, ' ', null, false);
            $mform->addElement('hidden', 'I'.$step->scode, $resource->id);
            if ($option = get_record($optable, 'gid', $gid, 'ptype', $type, 'pid', $resource->id)) {
                $mform->setDefault($step->scode, $option->pcode);
                $mform->setDefault('L'.$step->scode, $option->plimit);
                $mform->setDefault('P'.$step->scode, $option->pparams);
                $mform->setDefault('C'.$step->scode, $option->pcriteria);
                if ($option->phidden == 1) {
                    $mform->setDefault('H'.$step->scode, 'checked');
                }
            } else {
                $mform->setDefault($step->scode, $step->scode);
                $mform->setDefault('L'.$step->scode, $step->slimit);
                $mform->setDefault('P'.$step->scode, $step->params);
                $mform->setDefault('C'.$step->scode, 3);
            }
            $i++;
        }
        $mform->addElement('static', 'line', ' ', '***********************************************');

        $type = 'sumquiz';
        $code = 'SUM_Q';
        $limit = 1;
        $step->slimit = $limit;
        $step->scode = $code;
        $step->sname = get_string('modulenameplural', 'quiz').' - '.get_string('moodlekremsuma', 'moodlekrem');
        $step->params = '';
        $mform->addElement('static', 'X'.$step->scode, '', '<b>'.$step->sname.'</b>');
        $mform->addElement('hidden', 'N'.$step->scode, $step->sname);
        $group=array();
        $group[] = &$mform->createElement('checkbox', 'H'.$step->scode, ' ', get_string('moodlekremhidden', 'moodlekrem').'? ... '.get_string('moodlekremcode', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', $step->scode);
            $group[] = &$mform->createElement('static', 'krit', ' ' ,' ... '.get_string('moodlekremcrit', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('select', 'C'.$step->scode, ' ', $sumrescrit);
            $group[] = &$mform->createElement('static', 'val', ' ' ,' '.get_string('moodlekremlimit', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', 'L'.$step->scode);
            $group[] = &$mform->createElement('static', 'parametry', ' ', ' ... '.get_string('moodlekremparams', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', 'P'.$step->scode);
        $mform->addGroup($group, $type.'grp', ' ', null, false);
        if ($option = get_record($optable, 'gid', $gid, 'ptype', $type)) {
                $mform->setDefault($step->scode, $option->pcode);
                $mform->setDefault('L'.$step->scode, $option->plimit);
                $mform->setDefault('P'.$step->scode, $option->pparams);
                $mform->setDefault('C'.$step->scode, $option->pcriteria);
                if ($option->phidden == 1) {
                    $mform->setDefault('H'.$step->scode, 'checked');
                }
        } else {
            $mform->setDefault($step->scode, $step->scode);
            $mform->setDefault('L'.$step->scode, $step->slimit);
            $mform->setDefault('P'.$step->scode, $step->params);
            $mform->setDefault('C'.$step->scode, 10);
        }

        // Kurz
        $mform->addElement('header', 'moodlekremsumcourse', get_string('course', 'moodle'));
        unset($step);
        $type = 'sumcourse';
        $code = 'SUM_C';
        $limit = 3;
        $step->slimit = $limit;
        $step->scode = $code;
        $step->sname = get_string('course', 'moodle').' - '.get_string('moodlekremsuma', 'moodlekrem');
        $step->params = 'SUM_R; SUM_A; SUM_Q';
        $mform->addElement('static', 'X'.$step->scode, '', '<b>'.$step->sname.'</b>');
        $mform->addElement('hidden', 'N'.$step->scode, $step->sname);
        $group=array();
        $group[] = &$mform->createElement('checkbox', 'H'.$step->scode, ' ', get_string('moodlekremhidden', 'moodlekrem').'? ... '.get_string('moodlekremcode', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', $step->scode);
            $group[] = &$mform->createElement('static', 'krit', ' ' ,' ... '.get_string('moodlekremcrit', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('select', 'C'.$step->scode, ' ', $currescrit);
            $group[] = &$mform->createElement('static', 'val', ' ' ,' '.get_string('moodlekremlimit', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', 'L'.$step->scode);
            $group[] = &$mform->createElement('static', 'parametry', ' ', ' ... '.get_string('moodlekremparams', 'moodlekrem').':&nbsp;&nbsp;');
            $group[] = &$mform->createElement('text', 'P'.$step->scode);
        $mform->addGroup($group, $type.'grp', ' ', null, false);
        if ($option = get_record($optable, 'gid', $gid, 'ptype', $type)) {
                $mform->setDefault($step->scode, $option->pcode);
                $mform->setDefault('L'.$step->scode, $option->plimit);
                $mform->setDefault('P'.$step->scode, $option->pparams);
                $mform->setDefault('C'.$step->scode, $option->pcriteria);
                if ($option->phidden == 1) {
                    $mform->setDefault('H'.$step->scode, 'checked');
                }
        } else {
            $mform->setDefault($step->scode, $step->scode);
            $mform->setDefault('L'.$step->scode, $step->slimit);
            $mform->setDefault('P'.$step->scode, $step->params);
            $mform->setDefault('C'.$step->scode, 5);
        }

//-------------------------------------------------------------------------------
        // add standard elements, common to all modules
        $this->standard_coursemodule_elements(array('groups'=>false, 'groupmembersonly'=>true, 'gradecat'=>false));
//-------------------------------------------------------------------------------
        // add standard buttons, common to all modules
        $this->add_action_buttons();

    }

    function validation($data, $files) {
        global $CFG;
        global $COURSE;

        $errors = parent::validation($data, $files);

        $cid = $COURSE->id;
        $gid = (int)$this->_instance;
        $table = 'moodlekrem_options';

        delete_records($table, 'gid', $gid);

        //Studijní materiály
        $type = 'resource';
        $codepref = 'R';
        $recs = count_records($type, 'course', $cid);
        unset($par);
        $par->gid = $gid;
        $par->ptype = $type;
        for ($i=1; $i<=$recs; $i++) {
            $par->pcode = $codepref.$i;
            $key = 'I'.$par->pcode;
            $par->pid = $data[$key];
            $key = 'N'.$par->pcode;
            $par->pname = $data[$key];
            $key = 'C'.$par->pcode;
            $par->pcriteria = $data[$key];
            $key = 'H'.$par->pcode;
            $hidden = $data[$key];
            if ($hidden==1) {
                $par->phidden = 1;
            } else {
                $par->phidden = 0;
            }
            $key = 'L'.$par->pcode;
            $par->plimit = $data[$key];
            $key = 'P'.$par->pcode;
            $par->pparams = $data[$key];
            $par->modified = make_timestamp(date('Y'), date('m'), date('d'), date('H'), date('i'),date('s'));
            insert_record($table, $par);
        }

        // Celkem studijní materiály
        $type = 'sumresource';
        $codepref = 'SUM_R';
        unset($par);
        $par->gid = $gid;
        $par->ptype = $type;
        $par->pcode = $codepref;
        $par->pid = 0;
        $key = 'N'.$par->pcode;
        $par->pname = $data[$key];
        $key = 'C'.$par->pcode;
        $par->pcriteria = $data[$key];
        $key = 'H'.$par->pcode;
        $hidden = $data[$key];
        if ($hidden==1) {
             $par->phidden = 1;
        } else {
             $par->phidden = 0;
        }
        $key = 'L'.$par->pcode;
        $par->plimit = $data[$key];
        $key = 'P'.$par->pcode;
        $par->pparams = $data[$key];
        $par->modified = make_timestamp(date('Y'), date('m'), date('d'), date('H'), date('i'),date('s'));
        insert_record($table, $par);

        //Docházka
        $type = 'attendance';
        $codepref = 'A';
        $recs = count_records('attendance_sessions', 'courseid', $cid);
        unset($par);
        $par->gid = $gid;
        $par->ptype = $type;
        for ($i=1; $i<=$recs; $i++) {
            $par->pcode = $codepref.$i;
            $key = 'I'.$par->pcode;
            $par->pid = $data[$key];
            $key = 'N'.$par->pcode;
            $par->pname = $data[$key];
            $key = 'C'.$par->pcode;
            $par->pcriteria = $data[$key];
            $key = 'H'.$par->pcode;
            $hidden = $data[$key];
            if ($hidden==1) {
                $par->phidden = 1;
            } else {
                $par->phidden = 0;
            }
            $key = 'L'.$par->pcode;
            $par->plimit = $data[$key];
            $key = 'P'.$par->pcode;
            $par->pparams = $data[$key];
            $par->modified = make_timestamp(date('Y'), date('m'), date('d'), date('H'), date('i'),date('s'));
            insert_record($table, $par);
        }

        // Celkem docházka
        $type = 'sumattendance';
        $codepref = 'SUM_A';
        unset($par);
        $par->gid = $gid;
        $par->ptype = $type;
        $par->pcode = $codepref;
        $par->pid = 0;
        $key = 'N'.$par->pcode;
        $par->pname = $data[$key];
        $key = 'C'.$par->pcode;
        $par->pcriteria = $data[$key];
        $key = 'H'.$par->pcode;
        $hidden = $data[$key];
        if ($hidden==1) {
             $par->phidden = 1;
        } else {
             $par->phidden = 0;
        }
        $key = 'L'.$par->pcode;
        $par->plimit = $data[$key];
        $key = 'P'.$par->pcode;
        $par->pparams = $data[$key];
        $par->modified = make_timestamp(date('Y'), date('m'), date('d'), date('H'), date('i'),date('s'));
        insert_record($table, $par);

        //Testy
        $type = 'quiz';
        $codepref = 'Q';
        $recs = count_records($type, 'course', $cid);
        unset($par);
        $par->gid = $gid;
        $par->ptype = $type;
        for ($i=1; $i<=$recs; $i++) {
            $par->pcode = $codepref.$i;
            $key = 'I'.$par->pcode;
            $par->pid = $data[$key];
            $key = 'N'.$par->pcode;
            $par->pname = $data[$key];
            $key = 'C'.$par->pcode;
            $par->pcriteria = $data[$key];
            $key = 'H'.$par->pcode;
            $hidden = $data[$key];
            if ($hidden==1) {
                $par->phidden = 1;
            } else {
                $par->phidden = 0;
            }
            $key = 'L'.$par->pcode;
            $par->plimit = $data[$key];
            $key = 'P'.$par->pcode;
            $par->pparams = $data[$key];
            $par->modified = make_timestamp(date('Y'), date('m'), date('d'), date('H'), date('i'),date('s'));
            insert_record($table, $par);
        }

        // Celkem testy
        $type = 'sumquiz';
        $codepref = 'SUM_Q';
        unset($par);
        $par->gid = $gid;
        $par->ptype = $type;
        $par->pcode = $codepref;
        $par->pid = 0;
        $key = 'N'.$par->pcode;
        $par->pname = $data[$key];
        $key = 'C'.$par->pcode;
        $par->pcriteria = $data[$key];
        $key = 'H'.$par->pcode;
        $hidden = $data[$key];
        if ($hidden==1) {
             $par->phidden = 1;
        } else {
             $par->phidden = 0;
        }
        $key = 'L'.$par->pcode;
        $par->plimit = $data[$key];
        $key = 'P'.$par->pcode;
        $par->pparams = $data[$key];
        $par->modified = make_timestamp(date('Y'), date('m'), date('d'), date('H'), date('i'),date('s'));
        insert_record($table, $par);

        // Celkem kurz
        $type = 'sumcourse';
        $codepref = 'SUM_C';
        unset($par);
        $par->gid = $gid;
        $par->ptype = $type;
        $par->pcode = $codepref;
        $par->pid = 0;
        $key = 'N'.$par->pcode;
        $par->pname = $data[$key];
        $key = 'C'.$par->pcode;
        $par->pcriteria = $data[$key];
        $key = 'H'.$par->pcode;
        $hidden = $data[$key];
        if ($hidden==1) {
             $par->phidden = 1;
        } else {
             $par->phidden = 0;
        }
        $key = 'L'.$par->pcode;
        $par->plimit = $data[$key];
        $key = 'P'.$par->pcode;
        $par->pparams = $data[$key];
        $par->modified = make_timestamp(date('Y'), date('m'), date('d'), date('H'), date('i'),date('s'));
        insert_record($table, $par);

        return $errors;
    }
}

?>
